
package gov.va.med.mhv.health.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="OTHER_HEALTH_ISSUE")
public class OtherHealthIssue implements Serializable {
	
    /**
	 * 
	 */
	private static final long serialVersionUID = -2289451709436922940L;

	@Id
	@Column(name="HEALTH_ISSUE_ID_SEQ")
	@GeneratedValue(strategy=GenerationType.AUTO) 
	private Long id;
    
	@Column(name="OPLOCK")
	private Integer oplock;
	
	@Column(name="ISSUE")
	private String issue;
	
	@Column(name = "HEALTH_HIST_ID_SEQ", insertable = false, updatable = false)
	private Long healthHistId;

	@ManyToOne
	@JoinColumn(name="HEALTH_HIST_ID_SEQ" )
	private HealthHistoryRecord healthHistoryRecord;
	

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getIssue() {
		return issue;
	}

	public void setIssue(String issue) {
		this.issue = issue;
	}

	/**
	 * @return the healthHistoryRecord
	 */
	public HealthHistoryRecord getHealthHistoryRecord() {
		return healthHistoryRecord;
	}

	/**
	 * @param healthHistoryrecord the healthHistoryrecord to set
	 */
	public void setHealthHistoryRecord(HealthHistoryRecord healthHistoryRecord) {
		this.healthHistoryRecord = healthHistoryRecord;
	}

	/**
	 * @return the healthHistId
	 */
	public Long getHealthHistId() {
		return healthHistId;
	}

	/**
	 * @param healthHistId the healthHistId to set
	 */
	public void setHealthHistId(Long healthHistId) {
		this.healthHistId = healthHistId;
	}
	
	public boolean equals(Object otherHealthIssue) {
		if (!(otherHealthIssue instanceof OtherHealthIssue)) {
			return false;
		}
		
		OtherHealthIssue other = (OtherHealthIssue) otherHealthIssue;
		return id == null ? false : id.equals(other.id) 
			&& issue == null ? false : issue.equals(other.issue);
			//&& healthHistId == null ? false : healthHistId.equals(other.healthHistId);
	}

}
